PvPBetClient = PvPBetClient or {}
PvPBetClient.Utils = PvPBetClient.Utils or {}
PvPBetClient.Utils.Locales = {
    [1] = { -- PT (Português)
        -- Tabs
        TAB_LOBBY = "LOBBY",
        TAB_CREATE = "CRIAR",
        TAB_RANK = "RANKING",
        TAB_RULES = "REGRAS",

        -- Lobby
        LOBBY_TITLE_LIST = "Partidas disponíveis:",
        LOBBY_BTN_CREATE_BIG = "Clique aqui para criar uma partida",
        LOBBY_BTN_ACCEPT = "ACEITAR",
        LOBBY_BTN_CLOSE = "CANCELAR", -- Botão de fechar/cancelar slot
        LOBBY_CARD_UNKNOWN = "Unknown",
        LOBBY_SUFFIX_COINS = "Coins",
        LOBBY_MODE_MD = "Até %d Pts | %s",
        LOBBY_FREE_BET = "Aposta Grátis",
        
        -- Currencies
        CURRENCY_NAME_1 = "WCoinC",
        CURRENCY_ABBR_1 = "WC",
        CURRENCY_NAME_2 = "WCoinP",
        CURRENCY_ABBR_2 = "WP",
        CURRENCY_NAME_3 = "Goblin Point",
        CURRENCY_ABBR_3 = "GP",
        CURRENCY_NAME_4 = "Zen",
        CURRENCY_ABBR_4 = "Zen",
        CURRENCY_NAME_5 = "Grátis",
        CURRENCY_ABBR_5 = "Free",
        
        -- Create Match
        CREATE_TITLE = "Configurar Partida",
        CREATE_LABEL_VALUE = "Valor:",
        CREATE_LABEL_TYPE = "Tipo:",
        CREATE_BTN_ACTION = "DUELAR",
        CREATE_BTN_CANCEL = "CANCELAR",
        CREATE_SELECT_DEFAULT = "Select",
        
        MATCH_TYPE_1 = "Até 1 Ponto",
        MATCH_TYPE_3 = "Até 3 Pontos",
        MATCH_TYPE_5 = "Até 5 Pontos",
        
        -- Ranking
        RANK_TITLE = "Ranking PvPBet",
        RANK_BTN_WIN = "WIN",
        RANK_BTN_LOSE = "LOSE",
        RANK_BTN_KILL = "KILL",
        RANK_BTN_DEATH = "DEATH",
        RANK_BTN_TOTAL = "TOTAL",
        
        RANK_HEADER_PLAYER = "JOGADOR",
        RANK_HEADER_WIN = "WIN",
        RANK_HEADER_LOSE = "LOSE",
        RANK_HEADER_KILL = "KILL",
        RANK_HEADER_DEATH = "DEATH",
        RANK_HEADER_TOTAL = "TOTAL",
        RANK_EMPTY = "Nenhum ranking disponível.",
        
        -- Info / Rules
        INFO_TITLE = "Informações do Sistema",
        INFO_INTRO_1 = "O PvPBet é um sistema de combate por apostas",
        INFO_INTRO_2 = "onde 2 jogadores disputam prêmios em moedas.",
        INFO_INTRO_3 = "Vence quem atingir o objetivo de abates primeiro.",
        
        RULE_FEE = "Taxa da Casa: %d%% do Pote",
        RULE_GIVEUP = "Desistência = Derrota (W.O.)",
        RULE_LOCKED = "Apostas Travadas ao Iniciar",
        RULE_CONFIRM = "Confirmar Início: %d Segundos",
        RULE_TIME = "Tempo Limite: %d Minutos",
        RULE_WIN = "Vitória: Meta de Abates",
        RULE_REQ = "Req: Nível %d / Sem PK",
        RULE_AUTOCANCEL = "Auto-Cancel ao Criar Outra",
        RULE_MAPS = "Proibido Mapas de Evento",
        RULE_BAN = "Hack/Macro = Banimento",
        
        -- Popups & Scoreboard
        POPUP_CONFIRM_TITLE = "CONFIRMAR",
        POPUP_WAITING_TITLE = "AGUARDANDO...",
        SCOREBOARD_VS = "VS",
        
        -- System Messages
        MSG_TIMEOUT = "Tempo esgotado",
        MSG_NO_MESSAGE = "Nenhuma mensagem recebida do servidor.",
    },
    [2] = { -- EN (English)
        -- Tabs
        TAB_LOBBY = "LOBBY",
        TAB_CREATE = "CREATE",
        TAB_RANK = "RANKING",
        TAB_RULES = "RULES",

        -- Lobby
        LOBBY_TITLE_LIST = "Available Matches:",
        LOBBY_BTN_CREATE_BIG = "Click here to create a match",
        LOBBY_BTN_ACCEPT = "ACCEPT",
        LOBBY_BTN_CLOSE = "CANCEL",
        LOBBY_CARD_UNKNOWN = "Unknown",
        LOBBY_SUFFIX_COINS = "Coins",
        LOBBY_MODE_MD = "To %d Pts | %s",
        LOBBY_FREE_BET = "Free Bet",
        
        -- Currencies
        CURRENCY_NAME_1 = "WCoinC",
        CURRENCY_ABBR_1 = "WC",
        CURRENCY_NAME_2 = "WCoinP",
        CURRENCY_ABBR_2 = "WP",
        CURRENCY_NAME_3 = "Goblin Point",
        CURRENCY_ABBR_3 = "GP",
        CURRENCY_NAME_4 = "Zen",
        CURRENCY_ABBR_4 = "Zen",
        CURRENCY_NAME_5 = "Free",
        CURRENCY_ABBR_5 = "Free",
        
        -- Create Match
        CREATE_TITLE = "Match Setup",
        CREATE_LABEL_VALUE = "Value:",
        CREATE_LABEL_TYPE = "Type:",
        CREATE_BTN_ACTION = "DUEL",
        CREATE_BTN_CANCEL = "CANCEL",
        CREATE_SELECT_DEFAULT = "Select",
        
        MATCH_TYPE_1 = "To 1 Point",
        MATCH_TYPE_3 = "To 3 Points",
        MATCH_TYPE_5 = "To 5 Points",
        
        -- Ranking
        RANK_TITLE = "PvPBet Ranking",
        RANK_BTN_WIN = "WIN",
        RANK_BTN_LOSE = "LOSE",
        RANK_BTN_KILL = "KILL",
        RANK_BTN_DEATH = "DEATH",
        RANK_BTN_TOTAL = "TOTAL",
        
        RANK_HEADER_PLAYER = "PLAYER",
        RANK_HEADER_WIN = "WIN",
        RANK_HEADER_LOSE = "LOSE",
        RANK_HEADER_KILL = "KILL",
        RANK_HEADER_DEATH = "DEATH",
        RANK_HEADER_TOTAL = "TOTAL",
        RANK_EMPTY = "No ranking available.",
        
        -- Info / Rules
        INFO_TITLE = "System Information",
        INFO_INTRO_1 = "PvPBet is a betting combat system",
        INFO_INTRO_2 = "where 2 players compete for coin prizes.",
        INFO_INTRO_3 = "First to reach the kill target wins.",
        
        RULE_FEE = "House Fee: %d%% of Pot",
        RULE_GIVEUP = "Give Up = Defeat (W.O.)",
        RULE_LOCKED = "Bets Locked on Start",
        RULE_CONFIRM = "Start Confirm: %d Seconds",
        RULE_TIME = "Time Limit: %d Minutes",
        RULE_WIN = "Victory: Kill Target",
        RULE_REQ = "Req: Level %d / No PK",
        RULE_AUTOCANCEL = "Auto-Cancel on New Create",
        RULE_MAPS = "Event Maps Prohibited",
        RULE_BAN = "Hack/Macro = Ban",
        
        -- Popups & Scoreboard
        POPUP_CONFIRM_TITLE = "CONFIRM",
        POPUP_WAITING_TITLE = "WAITING...",
        SCOREBOARD_VS = "VS",
        
        -- System Messages
        MSG_TIMEOUT = "Time out",
        MSG_NO_MESSAGE = "No message received from server.",
    },
    [3] = { -- ES (Español)
        -- Tabs
        TAB_LOBBY = "LOBBY",
        TAB_CREATE = "CREAR",
        TAB_RANK = "RANKING",
        TAB_RULES = "REGLAS",

        -- Lobby
        LOBBY_TITLE_LIST = "Partidas disponibles:",
        LOBBY_BTN_CREATE_BIG = "Haga clic aquí para crear una partida",
        LOBBY_BTN_ACCEPT = "ACEPTAR",
        LOBBY_BTN_CLOSE = "CANCELAR",
        LOBBY_CARD_UNKNOWN = "Desconocido",
        LOBBY_SUFFIX_COINS = "Coins",
        LOBBY_MODE_MD = "Hasta %d Pts | %s",
        LOBBY_FREE_BET = "Apuesta Gratis",
        
        -- Currencies
        CURRENCY_NAME_1 = "WCoinC",
        CURRENCY_ABBR_1 = "WC",
        CURRENCY_NAME_2 = "WCoinP",
        CURRENCY_ABBR_2 = "WP",
        CURRENCY_NAME_3 = "Goblin Point",
        CURRENCY_ABBR_3 = "GP",
        CURRENCY_NAME_4 = "Zen",
        CURRENCY_ABBR_4 = "Zen",
        CURRENCY_NAME_5 = "Gratis",
        CURRENCY_ABBR_5 = "Free",
        
        -- Create Match
        CREATE_TITLE = "Configurar Partida",
        CREATE_LABEL_VALUE = "Valor:",
        CREATE_LABEL_TYPE = "Tipo:",
        CREATE_BTN_ACTION = "DUELAR",
        CREATE_BTN_CANCEL = "CANCELAR",
        CREATE_SELECT_DEFAULT = "Seleccionar",
        
        MATCH_TYPE_1 = "Hasta 1 Punto",
        MATCH_TYPE_3 = "Hasta 3 Puntos",
        MATCH_TYPE_5 = "Hasta 5 Puntos",
        
        -- Ranking
        RANK_TITLE = "Ranking PvPBet",
        RANK_BTN_WIN = "WIN",
        RANK_BTN_LOSE = "LOSE",
        RANK_BTN_KILL = "KILL",
        RANK_BTN_DEATH = "DEATH",
        RANK_BTN_TOTAL = "TOTAL",
        
        RANK_HEADER_PLAYER = "JUGADOR",
        RANK_HEADER_WIN = "WIN",
        RANK_HEADER_LOSE = "LOSE",
        RANK_HEADER_KILL = "KILL",
        RANK_HEADER_DEATH = "DEATH",
        RANK_HEADER_TOTAL = "TOTAL",
        RANK_EMPTY = "No hay ranking disponible.",
        
        -- Info / Rules
        INFO_TITLE = "Información del Sistema",
        INFO_INTRO_1 = "PvPBet es un sistema de combate por apuestas",
        INFO_INTRO_2 = "donde 2 jugadores compiten por premios.",
        INFO_INTRO_3 = "Gana quien alcance el objetivo de muertes primero.",
        
        RULE_FEE = "Tarifa de la Casa: %d%% del Bote",
        RULE_GIVEUP = "Rendirse = Derrota (W.O.)",
        RULE_LOCKED = "Apuestas Bloqueadas al Inicio",
        RULE_CONFIRM = "Confirmar Início: %d Segundos",
        RULE_TIME = "Límite de Tiempo: %d Minutos",
        RULE_WIN = "Victoria: Meta de Muertes",
        RULE_REQ = "Req: Nivel %d / Sin PK",
        RULE_AUTOCANCEL = "Auto-Cancel al Crear Otra",
        RULE_MAPS = "Mapas de Evento Prohibidos",
        RULE_BAN = "Hack/Macro = Prohibición",
        
        -- Popups & Scoreboard
        POPUP_CONFIRM_TITLE = "CONFIRMAR",
        POPUP_WAITING_TITLE = "ESPERANDO...",
        SCOREBOARD_VS = "VS",
        
        -- System Messages
        MSG_TIMEOUT = "Tiempo agotado",
        MSG_NO_MESSAGE = "Ningún mensaje recibido del servidor.",
    }
}

function PvPBetClient.Utils.GetText(key, ...)
    -- Usa 1 (PT) como padrão se Config ou Language não estiverem definidos
    local lang = (PvPBetClient.Config and PvPBetClient.Config.Language) or 1
    local dict = PvPBetClient.Utils.Locales[lang] or PvPBetClient.Utils.Locales[1]
    local text = dict[key] or key
    
    if ... then
        return string.format(text, ...)
    end
    return text
end