Config = {}

-- ============================================================================
-- SMARTWINDOW CLIENT CONFIGURATION
-- ============================================================================

-- ----------------------------------------------------------------------------
-- EVENT NAMES
-- ----------------------------------------------------------------------------

-- The LEFT side ["Key"] is the original system name (DO NOT CHANGE).
-- The RIGHT side "Value" is the name displayed in-game (You can change).
-- If you leave it empty "" or remove the line, the original name will be used.

Config.EventNames = {
    -- Standard Events
    ["BloodCastle"]     = "Blood Castle",
    ["ChaosCastle"]     = "Chaos Castle",
    ["DevilSquare"]     = "Devil Square",
    ["IllusionTemple"]  = "Illusion Temple",
    ["TvT"]             = "Team vs Team",
    ["GvG"]             = "Guild vs Guild",
    ["BattleRoyale"]    = "Battle Royale",
    ["Pandora"]         = "Pandora Event",
    ["ReiDoMU"]         = "King of MU - ArkaWar",

    -- Custom Events
    ["PvpChampionship"]     = "PvpChampionship",
    ["Marathon"]            = "Marathon",
    ["BonusManager"]        = "Bonus Time",
    ["MossMerchant"]        = "Moss Merchant",
    ["CustomEventDrop"]     = "Happy Hour Drop",
    ["CustomQuiz"]          = "Quiz Event",
    ["CustomOnlineLottery"] = "Online Lottery",
}

-- ----------------------------------------------------------------------------
-- EVENT TOOLTIPS
-- ----------------------------------------------------------------------------
-- Defines the description that appears when hovering over the event.
-- Format: ["OriginalName"] = "Description Text"
-- Use \n for manual line break, but the system wraps automatically.

Config.EventTooltips = {

    ["DevilSquare"] = "Survive waves of increasingly stronger monsters and prove your strength in the Devil Square.",
    ["ChaosCastle"] = "Fight to the death in a collapsing castle. The last survivor wins glory and prizes.",
    ["TvT"] = "Battle between Blue and Red teams. The team with the most kills wins.",
}

-- ----------------------------------------------------------------------------
-- MONSTER SCALES
-- ----------------------------------------------------------------------------
-- Defines the monster image size in the details interface.
-- Format: [MONSTER_ID] = SCALE (1.0 = Normal, 0.5 = Half, 2.0 = Double)
-- Manually add the IDs you want to adjust.

Config.MonsterScales = {
    -- Example:
    [561] = 1.0, -- Medusa
    [275] = 0.8, -- Kundun
    [501] = 0.6, -- Kundun
    [42] = 0.6, -- Red Dragon
    [626] = 0.7, -- Zhulong


}

-- ----------------------------------------------------------------------------
-- INVASION NOTES - BY ID (InvasionManager.dat)
-- ----------------------------------------------------------------------------
-- Defines the description based on the Invasion ID (Index Column in InvasionManager.dat).
-- Format: [ID] = "Description Text"

Config.InvasionNotes = {
    -- Example based on your InvasionManager.dat:
    [0] = "The Skeleton King has awakened in Lorencia!",
    [1] = "Red Dragons have invaded the continent.",
    [17] = "The Immortal Hydra has appeared in the depths of Atlans.",

}

-- ----------------------------------------------------------------------------
-- CUSTOM INVASION LIST MODE
-- ----------------------------------------------------------------------------
-- Defines if rewards will be displayed as a list (text) instead of a grid (icons).
-- Format: ["InvasionName"] = true or [ID] = true
Config.CustomInvasionListMode = {
    -- Example:
  --   [3] = true,
    -- [0] = true,
}

-- ----------------------------------------------------------------------------
-- INTERFACE TEXTS
-- ----------------------------------------------------------------------------
Config.Texts = {
    -- Titles and Tabs (Used in SmartWindowClientCore.lua if configured)
    WINDOW_TITLE        = "EVENT WINDOW",
    TAB_EVENTS          = "Events",
    TAB_INVASIONS       = "Invasions",
    
    -- Status Messages
    STATUS_ONLINE       = "ON",
    
    -- Empty List Messages
    NO_EVENTS_ACTIVE    = "No Active Events",
    NO_INVASIONS_ACTIVE = "No Active Invasions",
    
    -- Invasion Details
    NO_REWARDS          = "No rewards available",
    UNKNOWN_NAME        = "Unknown",
    UNKNOWN_INVASION    = "Unknown Invasion",
    
    -- Footer / Information
    EXCELLENT_INFO      = "Green slots represent excellent items.",
    PROGRESS_INFO       = "Progress Info:",
}

return Config
