-- System\ProtocolCore.lua (UNIFICADO - CLIENTE)
Protocol = {}
ProtocolFunctions = {}
local Handlers = {} -- Para Deathmatch y Misiones
local Legacy_Handles = {} -- Para Codex y WindowHUD

-- Cargamos la librería JSON profesional
Json = require("Util\\Json")

-- Soporte para scripts antiguos (Codex / WindowHUD)
function ProtocolFunctions.ClientProtocol(callback)
    table.insert(Legacy_Handles, { callback = callback })
end

-- ÚNICA CONEXIÓN AL MOTOR LOUIS
BridgeFunctionAttach('ClientProtocol', 'ProtocolMainRecv')

function ProtocolMainRecv(Packet, PacketName)
-- LÍNEA DE DEBUG:
    Console(3, "[Protocol-Debug] Paquete Recibido: " .. PacketName)
    local rawData = ""
    -- Leemos el paquete (PacketName es el origen de datos en tu emulador)
    for i = 0, 1024 do 
        local b = GetBytePacket(PacketName, i)
        if not b or b == 0 then break end
        rawData = rawData .. string.char(b)
		
    end

    -- 1. PROCESAMIENTO JSON (Sistemas Modernos: DM, Misiones, Anubis)
    if rawData ~= "" and rawData:sub(1,1) == "{" then
	Console(3, "[Protocol-Debug] Datos Raw: " .. rawData)
        local status, data = pcall(function() return Json.decode(rawData) end)
        
        if status and data and data.ID then
            -- Si existe un Handler registrado para este ID, lo ejecutamos
            if Handlers[data.ID] then
                for _, cb in ipairs(Handlers[data.ID]) do pcall(cb, data) end
            end
            -- No retornamos aquí para permitir que scripts legacy también analicen el paquete si lo necesitan
        end
    end

    -- 2. PROCESAMIENTO LEGACY (Sistemas Antiguos: Codex, WindowHUD)
    for _, handle in ipairs(Legacy_Handles) do
        pcall(handle.callback, Packet, PacketName)
    end
end

-- Registro para Deathmatch y Misiones
function Protocol.Register(id, callback)
    if not Handlers[id] then Handlers[id] = {} end
    table.insert(Handlers[id], callback)
end

function ProtocolFunctions.Init()
    -- Console(3, "[ProtocolCore] Sistema Unificado Cargado")
end
ProtocolFunctions.Init()

return Protocol